<?php

class USIN_Woocommerce_New_Customers_Loader extends USIN_Period_Report_Loader {
	
	protected function load_data(){
		global $wpdb;

		$subquery = USIN_Woocommerce::custom_order_tables_enabled() ? $this->get_subquery() : $this->get_legacy_subquery();

		$query = "SELECT COUNT(*) AS $this->total_col, first_order AS $this->label_col".
			" FROM ($subquery) AS order_dates GROUP BY {$this->get_group_by()}";

		return $wpdb->get_results( $query );
	}

	protected function get_subquery(){
		global $wpdb;

		$date_select = USIN_Query_Helper::get_gmt_offset_date_select('date_created_gmt');

		return $wpdb->prepare("SELECT MIN($date_select) AS first_order FROM {$wpdb->prefix}wc_orders".
			" WHERE type = %s GROUP BY billing_email".
			" HAVING first_order >= %s AND first_order <= %s", USIN_Woocommerce::ORDER_POST_TYPE, $this->get_period_start(), $this->get_period_end() );
	}

	protected function get_legacy_subquery(){
		global $wpdb;

		return $wpdb->prepare("SELECT MIN(post_date) AS first_order FROM $wpdb->posts AS posts".
			" INNER JOIN $wpdb->postmeta AS emails ON posts.ID = emails.post_id AND emails.meta_key = '_billing_email'".
			" WHERE posts.post_type = %s GROUP BY emails.meta_value".
			" HAVING first_order >= %s AND first_order <= %s", USIN_Woocommerce::ORDER_POST_TYPE, $this->get_period_start(), $this->get_period_end() );
	}
}